#version 130
#extension GL_EXT_gpu_shader4 : enable
// Wave of dotsMod01.fsh  by   csaez
  
//https://www.shadertoy.com/view/MtXyWX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// some constants
#define size 0.015
#define radius 0.09
#define speed 3.0
#define amplitude 4.0
#define spacing 0.1

// some functions
#define S(x) smoothstep(2.0 / iResolution.y, 0.0, x)
#define solidCircle(uv, p, r) S(length(uv - p) - r)
#define outlinedCircle(uv, p, r) S(abs(length(uv - p) - r))


//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float circles = 0.0;
    float guides = 0.0;

    vec2 uv = fragCoord / iResolution.y;
    ivec2 cell = ivec2(uv / spacing);
    for (int i=cell.x - 1; i<=cell.x + 2; i++) {
        for (int j=cell.y - 1; j<=cell.y + 2; j++) {
            
            vec2 offset = vec2(i, j) * spacing;
            guides += outlinedCircle(uv, offset, radius);

            float phase = float(i + j) * spacing * amplitude;
            float factor = (iTime * speed) + phase;
            vec2 pos = (vec2(cos(factor), sin(factor)) * radius) + offset;
            circles += solidCircle(uv, pos, size);
        }
    }

	fragColor = vec4(circles + 0.3 * guides);
	return fragColor;
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.